-- SP_UPDATERESPONDENT
-- Need to convert the callback date to UTC via SQL and not through IntWeb.

set ANSI_NULLS ON
set QUOTED_IDENTIFIER ON
GO
ALTER  PROCEDURE [dbo].[sp_UpdateRespondent]  
@ProjectId int,
@UserId int,
@CollectMode int,
@ResRespondent varchar(10),
@ResLanguage int,
@ResTimeZone int,
@ResCallBackDate DateTime,
@ResIntervCall varchar(10),
@ResTimeSlot bit,
@ResCallCount int,
@ResLastCallDate datetime,
@ResVersion varchar(10),
@ResPriority int,
@ResCompleted bit,
@ResConfidPhone bit,
@ResSeed float,
@ResPhone varchar(20),
@ResCodeResult varchar(2),
@ResWaveNo int,
@ResBlocked bit,
@ResCompPredictive bit,
@ResCall bit,
@ResMonitored bit,
@ResLastCompQuest int,
@ResPreviousCallDate DateTime,
@ResWaveImportNo int,
@ServerTimeZone int
AS
update Respondent set
ProjectId = @ProjectId,
CollectMode = case when @CollectMode <0 then CollectMode else @CollectMode end,
ModifiedBy = @UserId,
Modified = GETUTCDATE(),
ResLanguage = @ResLanguage,
ResTimeZone = @ResTimeZone,
ResCallBackDate = dbo.VX_fn_ToUTC(@ResCallBackDate, @ServerTimeZone),
ResIntervCall = @ResIntervCall,
ResTimeSlot = @ResTimeSlot,
ResCallCount = @ResCallCount,
ResLastCallDate = @ResLastCallDate,
ResVersion = @ResVersion,
ResPriority = @ResPriority,
ResCompleted = @ResCompleted,
ResConfidPhone = @ResConfidPhone,
ResSeed = @ResSeed,
ResPhone = @ResPhone,
ResCodeResult = @ResCodeResult,
ResWaveNo = @ResWaveNo,
ResBlocked = @ResBlocked,
ResCompPredictive = @ResCompPredictive,
ResCall = @ResCall,
ResMonitored = @ResMonitored,
ResLastCompQuest = @ResLastCompQuest,
ResPreviousCallDate = @ResPreviousCallDate,
ResWaveImportNo = @ResWaveImportNo
where 
ResRespondent = @ResRespondent
if @@ROWCOUNT = 0
begin
insert into respondent
(
ResRespondent,
ProjectId,
CollectMode,
ModifiedBy,
Modified,
ResLanguage,
ResTimeZone,
ResCallBackDate,
ResIntervCall,
ResTimeSlot,
ResCallCount,
ResLastCallDate,
ResVersion,
ResPriority,
ResCompleted,
ResConfidPhone,
ResSeed,
ResPhone,
ResCodeResult,
ResWaveNo,
ResBlocked,
ResCompPredictive,
ResCall,
ResMonitored,
ResLastCompQuest,
ResPreviousCallDate,
ResWaveImportNo)
values
(
@ResRespondent,
@ProjectId,
@CollectMode,
@UserId,
GETUTCDATE(),
@ResLanguage,
@ResTimeZone,
dbo.[VX_fn_ToUTC](@ResCallBackDate, @ServerTimeZone),
@ResIntervCall,
@ResTimeSlot,
@ResCallCount,
@ResLastCallDate,
@ResVersion,
@ResPriority,
@ResCompleted,
@ResConfidPhone,
@ResSeed,
@ResPhone,
@ResCodeResult,
@ResWaveNo,
@ResBlocked,
@ResCompPredictive,
@ResCall,
@ResMonitored,
@ResLastCompQuest,
@ResPreviousCallDate,
@ResWaveImportNo
) 
end
GO



CREATE PROCEDURE [dbo].[sp_RecomputeQuotaCountersWithoutOnlineReset] 
@projectId  int  ,@UserId int 
AS
declare @replicate bit 
select @replicate=InsValue from installation where insident = 'QUOTASMODEREPLICATE' 

if @replicate=1 
begin 
	update quota set qtunused=unused, qtfrequence=completed, qtonline=online from quota 
	inner join ( select stratum, sum(unused) as unused, sum(completed) as completed, sum(online) as online from 
	( select qtstratum as stratum, case when rescall=0 then 1 else 0 end as unused, 
		case when rescompleted=1 then 1 else 0 end as completed, 
		case when rescallbackdate>0 then 1 else 0 end as online 
	from quota 
	left outer join stratum on qtstratum=strstratum 
	left outer join respondent r on strrespondent=resrespondent where qtstratum > 0 ) a group by stratum ) b on stratum=qtstratum 
end 
else 
begin 
	update quota set qtunused=unused, qtfrequence=completed from quota 
	inner join ( select stratum, sum(unused) as unused, sum(completed) as completed from 
	( select qtstratum as stratum, case when rescall=0 then 1 else 0 end as unused, 
		case when rescompleted=1 then 1 else 0 end as completed 
		from quota 
		left outer join stratum on qtstratum=strstratum 
		left outer join respondent r on strrespondent=resrespondent 
		where qtstratum > 0 ) a 
	group by stratum ) b on stratum=qtstratum 
end 

update respondent set resintervcall=newintervcall from respondent 
inner join ( select respondent, case when qtgroup=0 then '' when qtgroup < 10 then 'G0' + cast(qtgroup as varchar) else 'G'+cast (qtgroup as varchar) end as newintervcall from ( select resrespondent as respondent, max(qtgroup) as qtgroup from ( select resrespondent, qtgroup from quota inner join stratum on strstratum=qtstratum inner join ( select resrespondent from respondent where rescall=0 and (resintervcall='' or resintervcall='***' or resintervcall like 'G[0-9][0-9]') ) a on resrespondent = strrespondent ) b group by resrespondent ) c ) d on resrespondent = respondent 

update quota set qtunused=(select count(resrespondent) from respondent where rescall=0),qtfrequence=(select count(resrespondent) from respondent where rescompleted=1) where qtstratum=0
GO


-- Changed way to extract code for the time zone (bug #11450)
ALTER  PROCEDURE [dbo].[sp_ImportRespondent]
(
@projectId int,
@userId int,
@resRespondent varchar(10),
@resLanguage int,
@resTimeZone int,
@resIntervCall varchar(4),
@resConfidPhone bit,
@resPhone varchar(20),
@resPriority int,
@resWaveImportNo int,
@resActive int,
@ExtractTimeZoneFromAreaCode bit,
@CheckPhoneForDuplicate bit
)
AS
if @CheckPhoneForDuplicate =1  and @resphone <> '' and @resphone is not null
begin
declare @key varchar(10)
select @key = resRespondent from dbo.respondent where resphone=@resphone
if @key is not null
begin
RAISERROR ('VOXCOERROR_1000 Duplicate phone numbers are not allowed.', 16, 1)
return
end
end
if @ExtractTimeZoneFromAreaCode =1
begin
declare @AreaCode varchar(3);
DECLARE @FirstNumPos smallint;
SET @FirstNumPos = PATINDEX('%[0-9]%', @resPhone)
set @AreaCode = SUBSTRING (@resPhone, @FirstNumPos, 3)
select @resTimeZone = coalesce(TimeZone,0) from dbo.AreaCodeTZ where code=@AreaCode
end
insert into dbo.respondent (ResRespondent,ResLanguage,ResTimeZone,ResCallbackDate,ResIntervCall,ResTimeSlot,ResCallCount,ResLastCallDate,ResVersion,ResPriority,ResCompleted,ResConfidPhone,ResSeed,Resphone,ResCodeResult,ResWaveNo,ResBlocked,ResCompPredictive,ResCall,ResMonitored,ResLastCompQuest,ResPreviousCallDate,ResWaveImportNo, ResActive, projectid,modifiedby,modified,collectmode)
values(
@resRespondent,
@resLanguage,
@resTimeZone,
0,
@resIntervCall,
0,
0,
null,
null,
@resPriority,
0,
@resConfidPhone,
@resRespondent,
@resPhone,
null,
0,
0,
0,
0,
0,
0,
null,
@resWaveImportNo,
@resActive,
@projectId,
@userId,
GETUTCDATE(),
0
)
if @ExtractTimeZoneFromAreaCode =1
begin
 declare @tzone varchar(2)
 if @resTimeZone <10  
  set @tzone = '0' + cast(@restimezone as varchar)
  else 
  set @tzone= cast(@restimezone as varchar)
 exec sp_UpdateRespondentResponse @projectId,@userId,0,@resRespondent,'TZONE',1,1,@tzone,'',0
end
GO